/**************************************************************************//**
 * @file     cp_ui.c
 * @brief    
 *
 * @author   
 * @version  V1.00
 *
 *
 * @whatsnew yyyy-mm-dd here add major revision changes
 *
 * @internal
 * @history yyyy-mm-dd 
 *
 *
 ******************************************************************************/

#include "project.h"

#include "cp.h"

/** @brief application entry to ask the comm layer to send a TLV to the peer
 *
 * 
 *  @param p_CommHandle Handle to a communication. This is an opaque handle passed to the application via cp_initCommLayerClient() or cp_initCommLayerServer().
 *  @param p_Tag Tag
 *  @param p_Val Value
 *  @param p_Pri Privilege level (see enumerator CP_PRILEVELS)
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 *
 * When successful, the communication layer will frame the TLV, queue it to communication and ensure that it is being resent until ACKED.
 */

CP_STATUSCODE cp_QueuePacketToComm(CP_COMMHANDLE p_CommHandle,unsigned long p_Tag,unsigned long p_Value,CP_PRILEVELS p_Pri)
{
    CP_MSGPUMPINFO a_CurrentComm;
    a_CurrentComm.m_Cmd = CP_CMD_SEND_SINGLE_PAYLOAD_TLV;
    a_CurrentComm.m_u.singleTLVpayloaddata.m_Tag = p_Tag;
    a_CurrentComm.m_u.singleTLVpayloaddata.m_Value = p_Value;
    // new telegs always start out as scheduled...
    a_CurrentComm.m_u.singleTLVpayloaddata.m_Status = TELEG_SCHEDULED;
    // Note: We happen to use sequenece numbers truly sequentially, but this is not necessarily the case (the spec explicitly allows non-incremental sequence numbers), so don't rely on it!
    a_CurrentComm.m_SeqNo = CP_NextSeqNo(p_CommHandle);
    if (CP_SendPriQueue(p_CommHandle->m_CommQueue,p_Pri,&a_CurrentComm) == CP_STATUSCODE_SUCCESS)
        return CP_STATUSCODE_SUCCESS;
    return CP_STATUSCODE_CORRUPT; // internal error. 
} 

/** @brief Application level dispatcher from payload packets received from the peer. 
 *
 * 
 *  @param p_Processor communication processor
 *  @param p_DynTagStruct chained list of dynamic tag structures
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 *
 * Add code here to support more tags. Response packets are NOT passed on to the application but processed internally.
 */

CP_STATUSCODE cp_EvaluateIncomingPacket(PCP_PROCESSOR p_Processor,CP_DYNTAGSTRUCT *p_DynTagStruct)
{
    switch (p_DynTagStruct->m_Tag)
    {
        case TAG_RESCHANGENOTIFICATION:
        {
            if (p_Processor->m_SingleTLVCallback)
                return (p_Processor->m_SingleTLVCallback)(p_DynTagStruct->m_Tag,p_DynTagStruct->m_Len,p_DynTagStruct->m_MarshalledVal);    
        }
        // add other tags here.
    }
    return CP_STATUSCODE_SUCCESS;
}

/** @brief Application level callback to implement authentication. 
 *
 * 
 *  @param p_DynTagStruct chained list of dynamic tag structures
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 *
 * The default implementation simply "authnticates" via a magic number TLV transmission to prevent port scan attacks. Here you can add code
 * to implement more sophisticated authentication schemes. This is called every time a TAG_AUTHREQUEST packet is received.
 */


CP_STATUSCODE cp_CB_AuthenticateClient(CP_DYNTAGSTRUCT *p_DynTagStruct)
{
    if (p_DynTagStruct->m_Len == sizeof(unsigned long))
    {
        unsigned long aValAsLong = htonl(*((unsigned long *)p_DynTagStruct->m_MarshalledVal));
        if (aValAsLong == CP_MAGIC_NUMBER_AUTHENTICATION)
            return CP_STATUSCODE_SUCCESS;
    }
    return CP_STATUSCODE_AUTHFAIL;
}

/** @brief Application level packet processing 
 *
 * 
 *  @param p_CommHandle Handle to a communication. This is an opaque handle passed to the application via cp_initCommLayerClient() or cp_initCommLayerServer().
 *  @param p_Callback A user specified function that will receives TLV contents from incoming packets via the communication layer.
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 *
 */

CP_STATUSCODE cp_RegisterIncomingSingleTLVPacketCallback(CP_COMMHANDLE p_CommHandle,CP_INCOMINGSINGLETLVPACKETCALLBACK p_Callback)
{
    p_CommHandle->m_SingleTLVCallback = p_Callback;
    return CP_STATUSCODE_SUCCESS;
}
